<?php
require 'config/config.php';

$id = $_GET['id'];

try {
    $stmt = $conn->prepare("SELECT invoices.*, customers.name as customer_name, customers.address as customer_address, customers.phone as customer_phone FROM invoices JOIN customers ON invoices.customer_id = customers.id WHERE invoices.id = :id");
    $stmt->bindParam(':id', $id);
    $stmt->execute();
    $invoice = $stmt->fetch(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $error_message = "Error: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Print Invoice</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/5.3.0-alpha1/css/bootstrap.min.css" integrity="sha384-KyZXEAg3QhqLMpG8r+Knujsl5/1j4CD7ksS7AA0e7DPiU6d9SXCp9p9y9lmJ02U6" crossorigin="anonymous">
    <style>
        @media print {
            .btn-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row mt-5">
            <div class="col-md-6 offset-md-3">
                <button class="btn btn-primary btn-print" onclick="window.print();">Print Invoice</button>
                <?php if (isset($error_message)): ?>
                    <div class="alert alert-danger" role="alert">
                        <?php echo $error_message; ?>
                    </div>
                <?php endif; ?>
                <h1 class="text-center">Invoice</h1>
                <table class="table">
                    <tr>
                        <th>Invoice ID</th>
                        <td><?php echo $invoice['id']; ?></td>
                    </tr>
                    <tr>
                        <th>Customer Name</th>
                        <td><?php echo $invoice['customer_name']; ?></td>
                    </tr>
                    <tr>
                        <th>Customer Address</th>
                        <td><?php echo $invoice['customer_address']; ?></td>
                    </tr>
                    <tr>
                        <th>Customer Phone</th>
                        <td><?php echo $invoice['customer_phone']; ?></td>
                    </tr>
                    <tr>
                        <th>Description</th>
                        <td><?php echo $invoice['description']; ?></td>
                    </tr>
                    <tr>
                        <th>Amount</th>
                        <td><?php echo $invoice['amount']; ?></td>
                    </tr>
                    <tr>
                        <th>Date</th>
                        <td><?php echo $invoice['date']; ?></td>
                    </tr>
                    <tr>
                        <th>Status</th>
                        <td><?php echo $invoice['status'] == 1 ? 'Paid' : 'Unpaid'; ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.7/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/5.3.0-alpha1/js/bootstrap.min.js" integrity="sha384-eT3p8Zq+AlUgJw0rydvtr6k7R2OFDsaX9Kx+FTcz5Wz2zRv1BtI1deI5jsSh3xt3" crossorigin="anonymous"></script>
</body>
</html>