<?php
require 'config/config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $customer_id = $_POST['customer_id'];
    $description = $_POST['description'];
    $amount = $_POST['amount'];

    try {
        $stmt = $conn->prepare("INSERT INTO invoices (customer_id, description, amount) VALUES (:customer_id, :description, :amount)");
        $stmt->bindParam(':customer_id', $customer_id);
        $stmt->bindParam(':description', $description);
        $stmt->bindParam(':amount', $amount);
        $stmt->execute();

        $message = "Invoice added successfully!";
        $alert_type = "success";
    } catch (PDOException $e) {
        $message = "Error: " . $e->getMessage();
        $alert_type = "danger";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Insert Invoice</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/5.3.0-alpha1/css/bootstrap.min.css" integrity="sha384-KyZXEAg3QhqLMpG8r+Knujsl5/1j4CD7ksS7AA0e7DPiU6d9SXCp9p9y9lmJ02U6" crossorigin="anonymous">
</head>
<body>
    <div class="container">
        <div class="row mt-5">
            <div class="col-md-6 offset-md-3">
                <div class="alert alert-<?php echo $alert_type; ?>" role="alert">
                    <?php echo $message; ?>
                </div>
                <a href="add_invoice.php" class="btn btn-primary">Back to Add Invoice</a>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.7/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/5.3.0-alpha1/js/bootstrap.min.js" integrity="sha384-eT3p8Zq+AlUgJw0rydvtr6k7R2OFDsaX9Kx+FTcz5Wz2zRv1BtI1deI5jsSh3xt3" crossorigin="anonymous"></script>
</body>
</html>
