<?php
require 'config/config.php';

$id = $_GET['id'];

try {
    $stmt = $conn->prepare("SELECT * FROM invoices WHERE id = :id");
    $stmt->bindParam(':id', $id);
    $stmt->execute();
    $invoice = $stmt->fetch(PDO::FETCH_ASSOC);

    $stmt2 = $conn->prepare("SELECT * FROM customers");
    $stmt2->execute();
    $customers = $stmt2->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $error_message = "Error: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Invoice</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/5.3.0-alpha1/css/bootstrap.min.css" integrity="sha384-KyZXEAg3QhqLMpG8r+Knujsl5/1j4CD7ksS7AA0e7DPiU6d9SXCp9p9y9lmJ02U6" crossorigin="anonymous">
</head>
<body>
    <div class="container">
        <h1 class="text-center mt-5 mb-4">Edit Invoice</h1>
        <?php if (isset($error_message)): ?>
            <div class="alert alert-danger" role="alert">
                <?php echo $error_message; ?>
            </div>
        <?php endif; ?>
        <div class="row">
            <div class="col-md-6 offset-md-3">
                <form action="update_invoice.php" method="post">
                    <input type="hidden" name="id" value="<?php echo $invoice['id']; ?>">
                    <div class="mb-3">
                        <label for="customer_id" class="form-label">Customer</label>
                        <select class="form-select" id="customer_id" name="customer_id" required>
                            <option selected disabled value="">Choose customer...</option>
                            <?php foreach ($customers as $customer): ?>
                                <option value="<?php echo $customer['id']; ?>" <?php echo ($customer['id'] == $invoice['customer_id']) ? 'selected' : ''; ?>><?php echo $customer['name']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control" id="description" name="description" rows="3" required><?php echo $invoice['description']; ?></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="amount" class="form-label">Amount</label>
                        <input type="number" class="form-control" id="amount" name="amount" step="0.01" min="0" value="<?php echo $invoice['amount']; ?>" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Update Invoice</button>
                </form>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.7/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/5.3.0-alpha1/js/bootstrap.min.js" integrity="sha384-eT3p8Zq+AlUgJw0rydvtr6k7R2OFDsaX9Kx+FTcz5Wz2zRv1BtI1deI5jsSh3xt3" crossorigin="anonymous"></script>
</body>
</html>

