-- Buat database
CREATE DATABASE invoice_app;
USE invoice_app;

-- Buat tabel customers
CREATE TABLE customers (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    email VARCHAR(255) NOT NULL UNIQUE,
    address TEXT NOT NULL
);

-- Buat tabel invoices
CREATE TABLE invoices (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    customer_id INT(11) NOT NULL,
    invoice_number VARCHAR(255) NOT NULL UNIQUE,
    amount DECIMAL(10, 2) NOT NULL,
    due_date DATE NOT NULL,
    status ENUM('unpaid', 'paid') NOT NULL DEFAULT 'unpaid',
    payment_date DATE,
    FOREIGN KEY (customer_id) REFERENCES customers (id)
);
